//-----------------------------------------------------------------------------
// Torque 2D
// 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

function OpenALInit()
{
   OpenALShutdownDriver();

   echo("");
   echo("OpenAL Driver Init:");

   echo ($pref::Audio::driver);

   if($pref::Audio::driver $= "OpenAL")
   {
      if(!OpenALInitDriver())
      {
         error("   Failed to initialize driver.");
         $Audio::initFailed = true;
      } else {
         // this should go here
         echo("   Vendor: " @ alGetString("AL_VENDOR"));
         echo("   Version: " @ alGetString("AL_VERSION"));  
         echo("   Renderer: " @ alGetString("AL_RENDERER"));
         echo("   Extensions: " @ alGetString("AL_EXTENSIONS"));

         alxListenerf( AL_GAIN_LINEAR, $pref::Audio::masterVolume );
   
         for (%channel=1; %channel <= 8; %channel++)
            alxSetChannelVolume(%channel, $pref::Audio::channelVolume[%channel]);

         echo("");
      }
   }

}


//--------------------------------------------------------------------------

function OpenALShutdown()
{
   OpenALShutdownDriver();
   //alxStopAll();
   //AudioGui.delete();
   //sButtonDown.delete();
   //sButtonOver.delete();
}


// --------------------------------------------------------------------
// Basic Audio.
// --------------------------------------------------------------------
new AudioDescription(clickAudio)
{
   volume   = 1.0;
   isLooping= false;
   is3D     = false;
   type     = 0;
};
   
// --------------------------------------------------------------------
// Click Sound.
// --------------------------------------------------------------------
new AudioProfile(clickSound)
{
	filename = "~/sounds/click.wav";
	description = clickAudio;
	preload = true;
};


// --------------------------------------------------------------------
// Play Click Sound.
// --------------------------------------------------------------------
function playClickSound()
{
	// Play Click Sound.
	alxPlay( clickSound );
}

