//-----------------------------------------------------------------------------
// Torque 2D. 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Create Scene.
//-----------------------------------------------------------------------------
function createScene()
{


	//--------------------------------------------------------------------------
	// Setup a background image
	//--------------------------------------------------------------------------
	%background = new fxChunkedSprite2D() { scenegraph = $pongSceneGraph2D; };
	%background.setPosition( "0 0" );
	%background.setSize( "100 75" );
	%background.setGroup( 3 );
	%background.setLayer( 11 );
	%background.setChunkedImage( backgroundImageChunk );

	//--------------------------------------------------------------------------
	// Player 1 Scoreboard
	//--------------------------------------------------------------------------
	// First Digit.
	%score = new fxStaticSprite2D(p1Score1) { scenegraph = $pongSceneGraph2D; };
	%score.setPosition( "-17 -30" );
	%score.setSize("5 5");
	%score.setGroup( 1 );
	%score.setLayer( 1 );
	%score.setImageMap( scoreMap, 0 );
   // Second Digit
	%score = new fxStaticSprite2D(p1Score2) { scenegraph = $pongSceneGraph2D; };
	%score.setPosition( "-12 -30" );
	%score.setSize("5 5");
	%score.setGroup( 1 );
	%score.setLayer( 1 );
	%score.setImageMap( scoreMap, 0 );

	//--------------------------------------------------------------------------
	// Player 2 Scoreboard
	//--------------------------------------------------------------------------
	// First Digit.
	%score = new fxStaticSprite2D(p2Score1) { scenegraph = $pongSceneGraph2D; };
	%score.setPosition( "10 -30" );
	%score.setSize("5 5");
	%score.setGroup( 2 );
	%score.setLayer( 2 );
	%score.setImageMap( scoreMap, 0 );
   // Second Digit	
	%score = new fxStaticSprite2D(p2Score2) { scenegraph = $pongSceneGraph2D; };
	%score.setPosition( "15 -30" );
	%score.setSize("5 5");
	%score.setGroup( 2 );
	%score.setLayer( 2 );
	%score.setImageMap( scoreMap, 0 );


	//--------------------------------------------------------------------------
	// Player 1 Tank
	//--------------------------------------------------------------------------	
	%tank = new fxStaticSprite2D(p1Tank) { scenegraph = $pongSceneGraph2D; };
	%tank.setSize("4 4");
	%tank.setPosition( "-45 4" );
	%tank.setGroup( 1 );
	%tank.setLayer( 1 );
	%tank.setImageMap( tank, 0 );
	%tank.setMaxLinearVelocity( 10 );
	%tank.setMaxAngularVelocity( 10 );
	%tank.setWorldLimit("STICKY","-47.3 -22.5 47.3 32.1");
	%tank.setCollisionScale( "1 1" );
   %tank.setCollisionMasks( BIT(3), BIT(10));	
	%tank.setCollisionActive( true, true );
   %tank.setCollisionPhysics( true, true );	
	%tank.fireLinkPoint = %tank.addLinkPoint("1 0");
	%tank.tag="tank1";
	%tank.setEnabled(true);	
	
	//--------------------------------------------------------------------------
	// Player 2 Tank
	//--------------------------------------------------------------------------	
	%tank = new fxStaticSprite2D(p2Tank) { scenegraph = $pongSceneGraph2D; };
	%tank.setSize("4 4");
	%tank.setRotation("180");
	%tank.setPosition( "45 4" );
	%tank.setGroup( 2 );
	%tank.setLayer( 2 );
	%tank.setImageMap( tank, 0 );
	%tank.setMaxLinearVelocity( 10 );
	%tank.setMaxAngularVelocity( 10 );
	%tank.setWorldLimit("STICKY","-47.3 -22.5 47.3 32.1");
	%tank.setCollisionScale( "1 1" );
	%tank.setCollisionMasks( BIT(3), BIT(10));
	%tank.setCollisionActive( true, true );
   %tank.setCollisionPhysics( true, true );
	%tank.addLinkPoint("1 0");
	%tank.fireLinkPoint = %tank.addLinkPoint("1 0");	
	%tank.tag="tank2";
	%tank.setEnabled(true);
	
	
	//--------------------------------------------------------------------------
	// Load the current map
	//--------------------------------------------------------------------------
	tankPong::loadMap("map" @ $currentMap);
}


//-----------------------------------------------------------------------------
// Change Maps to the next map.
//-----------------------------------------------------------------------------
function mapChange()
{
	$currentMap = $currentMap++;
	if ($currentMap > 3)
		$currentMap = 1;
	tankPong::loadMap("map" @ $currentMap);
}

//-----------------------------------------------------------------------------
// Load the map
//-----------------------------------------------------------------------------
function tankpong::loadMap(%map)
{
	if (isObject($tileMap))
		$tileMap.delete();
	// Create tile-map.
	$tileMap = new fxTileMap2D() { scenegraph = $pongSceneGraph2D; };
	// Load saved tile-map file.
	$tileMap.loadTileMap("~/client/maps/" @ %map @ ".map");
	
	// Load tile layer from tile-map
	%layer = $tileMap.getTileLayer( 0 );
	%layer.setGroup( 3 );
	%layer.setLayer( 10 );
	%layer.tag = "border";
	%layer.setPosition( "0 4" );
	%layer.setSize( "100 58.5" );
	%layer.setTileSize( "2.5 2.5" );
	fixCollision(%layer);
	%layer.setCollisionActive( false, true );	
}


//-----------------------------------------------------------------------------
// Re-build the map to resize the collision mesh for tiles.
//-----------------------------------------------------------------------------
function fixCollision(%layer)
{
	%tileCount = %layer.getTileCount();
	for (%x = 0; %x < getWord(%tileCount,0); %x++)
	{
		for (%y = 0; %y < getWord(%tileCount,1); %y++)
		{
			%collision = %layer.getTileCollision(%x SPC %y);
			%tile = %layer.getTileType(%x SPC %y);
			%layer.clearTile(%x SPC %y);
			%layer.setStaticTile(%x SPC %y, getWord(%tile,1));
			%layer.setTileCollisionActive(%x SPC %y, getWord(%collision,0));
		}
	}
}