//-----------------------------------------------------------------------------
// Initial Game State
//-----------------------------------------------------------------------------
$currentMap=1;
$player1score = 0;
$player2score = 0;
$p1Rotate = false;
$p1Back = false;
$p2Rotate = false;
$p2Back = false;


//-----------------------------------------------------------------------------
// Reset the game
//-----------------------------------------------------------------------------
function resetGame()
{
	resetTank(p1Tank);
	resetTank(p2Tank);
	p1Tank.setRotation("180");
	p2Tank.setRotation("0");
	$player1score = 0;
	$player2score = 0;
	setscore("1",0);
	setscore("2",0);	
}

//-----------------------------------------------------------------------------
// Set the Score
//-----------------------------------------------------------------------------
function setscore(%player,%score)
{
	// Get the seperate digits
	%score1 = mfloor(%score/10);
	%score2 = %score - (%score1 * 10);
	// Is the score for player 1 or player 2
	if (%player $= "1")
	{
		p1score1.setImageMap( scoreMap, %score1 );	
		p1score2.setImageMap( scoreMap, %score2 );
	}
	else
	{
		p2score1.setImageMap( scoreMap, %score1 );	
		p2score2.setImageMap( scoreMap, %score2 );		
	}	
}

//-----------------------------------------------------------------------------
// Movement Functions.
//-----------------------------------------------------------------------------
// Player 1
//-----------------------------------------------------------------------------
// Move Forward
function player1Forward()
{
	p1Tank.setLinearVelocityPolar( p1Tank.getRotation()+90,3 );
}
// Move Backward
function player1Back()
{
	p1Tank.setLinearVelocityPolar( p1Tank.getRotation()+90, -3 );
	$p1Back = true;
}
// Rotate the Tank
function player1Rotate(%dir)
{
	if (%dir $= 1)
	{
		p1Tank.setAngularVelocity(10);	
	}
	else
	{
		p1Tank.setAngularVelocity(-10);	
	}
	$p1Rotate = true;
	schedule(100,0,"rotate",1);
}
//Stop moving
function player1Stop()
{
	p1Tank.setLinearVelocity( "0 0" );
	$p1Back = false;
}
//Stop Rotating
function player1StopTurn()
{
	p1Tank.setAngularVelocity(0);
	$p1Rotate = false;
}

//-----------------------------------------------------------------------------
// Movement Functions.
//-----------------------------------------------------------------------------
// Player 2
//-----------------------------------------------------------------------------
// Move Forward
function player2Forward()
{
	p2Tank.setLinearVelocityPolar( p2Tank.getRotation()+90,3 );
}
// Move Backward
function player2Back()
{
	p2Tank.setLinearVelocityPolar( p2Tank.getRotation()+90, -3 );
	$p2Back = true;
}
// Rotate the Tank
function player2Rotate(%dir)
{
	if (%dir $= 1)
	{
		p2Tank.setAngularVelocity(10);	
	}
	else
	{
		p2Tank.setAngularVelocity(-10);	
	}
	$p2Rotate = true;
	schedule(100,0,"rotate",2);	
}
// Stop Moving
function player2Stop()
{
	p2Tank.setLinearVelocity( "0 0" );
	$p2Back = false;
}
// Stop Rotating
function player2StopTurn()
{
	p2Tank.setAngularVelocity(0);
	$p2Rotate = false;
	schedule(100,0,"rotate",2);		
}


//-----------------------------------------------------------------------------
// Movement Functions.
//-----------------------------------------------------------------------------
// Shared
//-----------------------------------------------------------------------------
// Shedule to add rotation to velocity
function rotate(%player)
{
	if (%player == 1)
	{
		if ($p1Back)
			p1Tank.setLinearVelocityPolar( p1Tank.getRotation()+90,0-vectorLength2D( p1Tank.getLinearVelocity() ) );
		else
			p1Tank.setLinearVelocityPolar( p1Tank.getRotation()+90,vectorLength2D( p1Tank.getLinearVelocity() ) );
		if ($P1Rotate)
			schedule(100,0,"rotate",1);
	}
	else
	{
		if ($p2Back)
			p2Tank.setLinearVelocityPolar( p2Tank.getRotation()+90,0-vectorLength2D( p2Tank.getLinearVelocity() ) );
		else
			p2Tank.setLinearVelocityPolar( p2Tank.getRotation()+90,vectorLength2D( p2Tank.getLinearVelocity() ) );
		if ($P2Rotate)
			schedule(100,0,"rotate",2);	
	}
}
//-----------------------------------------------------------------------------
// Handle Collision
//-----------------------------------------------------------------------------
function fxStaticSprite2D::onCollision( %srcObj, %dstObj, %srcRef, %dstRef, %time, %normal, %contactCount, %contacts )
{
	if (%srcObj.tag $= "ball")
	{
		alxplay(pong);
		if (%dstObj.tag $= "border")
		{
			if (%srcObj.getGroup() == 1)
			{
				%srcObj.setCollisionMasks( BIT(2)|BIT(3), BIT(2)|BIT(10));
				%srcObj.tag = "ball2";
			}
			else if (%srcObj.getGroup() == 2)
			{
				%srcObj.setCollisionMasks( BIT(1)|BIT(3), BIT(1)|BIT(10));
				%srcObj.tag = "ball2";
			}
		}
	}
	else if (%srcObj.tag $= "ball2")
	{
		alxplay(pong);
		
   	if (%dstObj.tag $= "tank1")
		{

			%dstObj.setMaxAngularVelocity(1000);
			%dstObj.setMaxLinearVelocity(200);
			%dstObj.setAngularVelocity(1000);			
			%dstObj.setLinearVelocityPolar( getRandom(0,360),200 );
			%dstObj.status = "dead";
			schedule(500,0,"resetTank",%dstObj,1);
			$player2score = $player2score++;
			setScore(2,$player2score);
			schedule(500,0,"resetTank",%dstObj,1);
			%srcObj.safeDelete();
		}
		else if (%dstObj.tag $= "tank2")
		{
			%dstObj.setMaxAngularVelocity(1000);
			%dstObj.setMaxLinearVelocity(200);
			%dstObj.setAngularVelocity(1000);		
			%dstObj.setLinearVelocityPolar( getRandom(0,360),200 );
			%dstObj.status = "dead";
			schedule(500,0,"resetTank",%dstObj,2);
			$player1score = $player1score++;
			setScore(2,$player1score);
			%srcObj.safeDelete();
		}
	}
}

//-----------------------------------------------------------------------------
// Reset the Tank stats
//-----------------------------------------------------------------------------
function resetTank(%obj)
{
		%obj.setMaxAngularVelocity(10);
		%obj.setMaxLinearVelocity(10);
		%obj.setAngularVelocity(0);				
		%obj.setLinearVelocity( "0 0" );

		%obj.status = "";
}

//-----------------------------------------------------------------------------
// Player 1 Fires
//-----------------------------------------------------------------------------
function player1fire()
{
	%ball = new fxStaticSprite2D() { scenegraph = $pongSceneGraph2D; };
	%ball.setSize("0.5 0.5");
	%ball.setPosition(p1Tank.getLinkPoint( p1Tank.fireLinkPoint ));
	%ball.setGroup( 1 );
	%ball.setLayer( 1 );
	%ball.setImageMap( ball, 0 );
	%ball.setMinLinearVelocity( 0 );
	%ball.setMaxAngularVelocity( 0 );	
	%ball.setCollisionMaterial( pongMaterial );
   %ball.setCollisionPolyPrimitive( 16 );	
	%ball.setCollisionScale( "0.77 0.77" );
	%ball.setCollisionActive( true, true );
	%ball.setCollisionPhysics( true, true );
	%ball.setCollisionMasks( BIT(3), BIT(10));
	%ball.setCollisionCallback( true );
	%ball.tag="ball";
	%ball.setEnabled(true);
	%ball.setLifetime(3);
	%ball.setLinearVelocityPolar( p1Tank.getRotation()+90, 35 );
}

//-----------------------------------------------------------------------------
// Player 2 Fires
//-----------------------------------------------------------------------------
function player2fire()
{
	%ball = new fxStaticSprite2D(ballSprite) { scenegraph = $pongSceneGraph2D; };
	%ball.setSize("0.5 0.5");
	%ball.setPosition(p2Tank.getLinkPoint(p2Tank.fireLinkPoint ));
	%ball.setGroup( 2 );
	%ball.setLayer( 2 );
	%ball.setImageMap( ball, 0 );
	%ball.setMinLinearVelocity( 0 );
	%ball.setMaxAngularVelocity( 0 );	
	%ball.setCollisionMaterial( pongMaterial );
   %ball.setCollisionPolyPrimitive( 16 );		
	%ball.setCollisionScale( "0.77 0.77" );
	%ball.setCollisionActive( true, true );
	%ball.setCollisionPhysics( true, true );
	%ball.setCollisionMasks( BIT(3), BIT(10));
	%ball.setCollisionCallback( true );
	%ball.tag="ball";
	%ball.setEnabled(true);
	%ball.setLifetime(3);
	%ball.setLinearVelocityPolar( p2Tank.getRotation()+90, 35 );
}	