//-----------------------------------------------------------------------------
// Torque 2D. 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

// --------------------------------------------------------------------
// Initialise Client.
// --------------------------------------------------------------------
function initialiseClient()
{

	InitCanvas("T2D - TankPong");
	
	// Load-up Datablocks.	
	exec("./datablocks.cs");
	exec("./scene.cs");

	// Load-up GUIs.
	exec("./mainScreenGui.gui");
	exec("./game.cs");
	exec("./config.cs");
	
	// Set GUI.
	Canvas.setContent(mainScreenGui);
	
	// Set Cursor.
	Canvas.setCursor(DefaultCursor);
	
	// Setup Scene.
	setupT2DScene();
}


// --------------------------------------------------------------------
// Destroy Client.
//
// Here we destroy the SceneGraph.
// --------------------------------------------------------------------
function destroyClient()
{
	// Destroy fxSceneGraph2D.
	if ( isObject(t2dSceneGraph) )
		t2dSceneGraph.delete();	
}


// --------------------------------------------------------------------
// Setup T2D Scene.
// --------------------------------------------------------------------
function setupT2DScene()
{
	// Create fxSceneGraph2D.
	$pongSceneGraph2D = new fxSceneGraph2D();
	
	// Associate Scenegraph with Window.
	pongSceneWindow2D.setSceneGraph( $pongSceneGraph2D );
	
	// Configure the Debug-Banner (could've used the defaults).
	pongSceneWindow2D.setDebugBanner( "Lucida Console", 12, "255 255 255 255", "0 0 255 128" );
	
	// Set Camera Position to be centered on (0,0) with
	// view width/height of (100/80).
	pongSceneWindow2D.setCurrentCameraPosition( "0 0 100 75" );

	
	// ************************************************************************
	//
	// Add your custom code here...
	//
	// ************************************************************************
	
	createScene();
	
}